#include "lg_gba.h"
#include "lg_gfx.h"

u16* FrontBuffer;
u16* BackBuffer;

void IWRAM_CODE SwitchBuffers(void)
{
	if(REG_DISPCNT & BACKBUFFER) {
		REG_DISPCNT &= ~BACKBUFFER;
		FrontBuffer = (u16*)0x6000000;
		BackBuffer = (u16*)0x600A000;
		return;
	}
	else {
		REG_DISPCNT |= BACKBUFFER;
		FrontBuffer = (u16*)0x600A000;
		BackBuffer = (u16*)0x6000000;
	}
}


